const path = require('path')

function resolve(dir) {
  return path.join(__dirname, dir)
}

module.exports = {
  publicPath: '/',
  lintOnSave: false,
  chainWebpack: (config) => {
    config.resolve.alias
      .set('@$', resolve('src'))
      .set('a', resolve('src/assets'))
      .set('c', resolve('src/components'))
      .set('v', resolve('src/views'))
      .set('r', resolve('src/request'))
      .set('config', resolve('src/config'))
      .set('common', resolve('src/common'))
      .set('store', resolve('src/store'))
  },
  // devServer: {
  //   host: 'localhost',
  //   port: 8080, // 端口号
  //   https: true, // https:{type:Boolean}
  // open: true, // 配置自动启动浏览器
  // hotOnly: true, // 热更新
  //   // proxy: {
  //   //   "/api": {
  //   //     target: "http://127.0.0.1:8080/",
  //   //     changeOrigin: true,
  //   //     pathRewrite: {
  //   //       "^/api": "",
  //   //     },
  //   //   },
  //   // },
  // },
  pluginOptions: {
    'style-resources-loader': {
      preProcessor: 'scss',
      patterns: [path.resolve(__dirname, 'src/assets/scss/index.scss')]
    }
  },
  css: {
    sourceMap: false,
    loaderOptions: {
      // postcss: {
      //   plugins: [
      //     require("postcss-px-to-viewport")({
      //       unitToConvert: "px",
      //       viewportWidth: 375,
      //       unitPrecision: 4,
      //       propList: ["*"],
      //       viewportUnit: "vw",
      //       fontViewportUnit: "vw",
      //       selectorBlackList: [],
      //       minPixelValue: 2,
      //       mediaQuery: false,
      //       replace: true,
      //     }),
      //   ],
      // },
      sass: {
        prependData: '@import "./src/assets/scss/index.scss";'
      }
    }
  }
}
